using System;

class Program
{
    struct Mast
    {
        public int x;
        public int h;
    }

    static void Main()
    {
        int n = int.Parse(Console.ReadLine());

        string[] xs = Console.ReadLine().Split(' ');
        string[] hs = Console.ReadLine().Split(' ');

        Mast[] a = new Mast[n];

        for (int i = 0; i < n; i++)
        {
            a[i].x = int.Parse(xs[i]);
            a[i].h = int.Parse(hs[i]);
        }

        Array.Sort(a, delegate (Mast m1, Mast m2)
        {
            return m1.x.CompareTo(m2.x);
        });

        for (int i = 0; i < n; i++)
        {
            int best = int.MaxValue;

            for (int j = 0; j < n; j++)
            {
                if (i == j) continue;

                if (a[j].h >= a[i].h)
                {
                    int dist = Math.Abs(a[j].x - a[i].x);
                    if (dist < best)
                        best = dist;
                }
            }

            for (int j = 0; j < n - 1; j++)
            {
                int x1 = a[j].x;
                int h1 = a[j].h;
                int x2 = a[j + 1].x;
                int h2 = a[j + 1].h;

             
                int xm2 = x1 + x2 + h1 - h2; 
            
                int maxH = Math.Max(h1, h2);
                if (maxH < a[i].h) continue;

                int xHit = x1 + (h1 - a[i].h);
                if (xHit >= x1 && xHit <= x2)
                {
                    int dist = Math.Abs(xHit - a[i].x);
                    if (dist < best)
                        best = dist;
                }

                xHit = x2 - (h2 - a[i].h);
                if (xHit >= x1 && xHit <= x2)
                {
                    int dist = Math.Abs(xHit - a[i].x);
                    if (dist < best)
                        best = dist;
                }
            }

            if (best == int.MaxValue)
                Console.WriteLine(-1);
            else
                Console.WriteLine(best);
        }
    }
}